﻿<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="System.Linq" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ import Namespace="System.Collections.Generic" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport sprzeday wg lokalizacji</title>

    <script runat="server">
		
        public enum SortowanieWedług { WgKoduLokalizacji, WgNazwyLokalizacji }

        public class ParametryContext : ContextBase {
            BusinessModule businessmodule;

            public ParametryContext(Context cx)
                : base(cx) {
                businessmodule = BusinessModule.GetInstance(cx.Session);
            }

            SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyLokalizacji;

            [DefaultWidth(50)]
            [Priority(10)]
            public SortowanieWedług SortujWedług {
                get { return sortujWedług; }
                set {
                    sortujWedług = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            private bool _ignorujZaliczkowe = true;

            [Soneta.Tools.Priority(20)]
            public bool IgnorujZaliczkowe {
                get {
                    return this._ignorujZaliczkowe;
                }
                set {
                    this._ignorujZaliczkowe = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            FeatureDefinition cechaLokalizacji;

            [Priority(30)]
            [Caption("Cecha lokalizacji")]
            public FeatureDefinition CechaLokalizacji {
                get { return cechaLokalizacji; }
                set
                {
                    cechaLokalizacji = value;
                    OnChanged(EventArgs.Empty);
                    var f = GetListWartoscCechyLokalizacji() as List<DictionaryItem>;
                    if (f == null)
                    {
                        wartoscCechyLokalizacji = new DictionaryItem[] { };
                    }
                    else
                    {
                        wartoscCechyLokalizacji = new DictionaryItem[] { ((List<DictionaryItem>)GetListWartoscCechyLokalizacji()).FirstOrDefault() };
                    }
                }
            }

            public object GetListCechaLokalizacji() {
                // TID:13162; 
                RowCondition rc = new FieldCondition.Equal("TableName", "Lokalizacje");
                rc &= new FieldCondition.Equal("TypeNumber", FeatureTypeNumber.String);
                rc &= new FieldCondition.NotEqual("Dictionary", String.Empty);
                return businessmodule.FeatureDefs.ByName[rc];
            }   
            
            DictionaryItem[] wartoscCechyLokalizacji;

            [Priority(40)]
            [Caption("Wartość cechy lokal.")]
            public DictionaryItem[] WartoscCechyLokalizacji
            {
                get { return wartoscCechyLokalizacji; }
                set { wartoscCechyLokalizacji = value; OnChanged(EventArgs.Empty); }
            }

            public object GetListWartoscCechyLokalizacji()
            {
                var al = new List<DictionaryItem>();
                if (cechaLokalizacji == null)
                    return al;
                FeatureDefinition fd = businessmodule.FeatureDefs.ByName["Lokalizacje".TranslateIgnore(), cechaLokalizacji.Name];
                if (fd == null)
                    return al;
                if (fd.DictionaryList != null)
                {
                    foreach (DictionaryItem di in fd.DictionaryList)
                    {
                        al.Add(di);
                    }
                }
                var s = new string[] { "Caption".TranslateIgnore() };
                var lookupDef = new LookupInfo(new LookupInfo.EnumerableItem("Cechy", al, s));
                return lookupDef;
            }

            public bool IsReadOnlyWartoscCechyLokalizacji()
            {
                return cechaLokalizacji == null || (wartoscCechyLokalizacji.Count() == 1 && wartoscCechyLokalizacji[0] == null);
            }
        }

        static ParametryContext parametry;

        [Context]
        public static ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total {
            readonly Lokalizacja lokalizacja;
            decimal netto;
            decimal vat;
            decimal brutto;
            public Total(Lokalizacja lokalizacja)
            {
                this.lokalizacja = lokalizacja;
            }
            public void Add(DokumentHandlowy dokument) {
                netto += dokument.Suma.Netto;
                vat += dokument.Suma.VAT;
                brutto += dokument.Suma.Brutto;
            }
            public Lokalizacja Lokalizacja {
                get { return lokalizacja; }
            }
            public decimal Netto {
                get { return netto; }
            }
            public decimal VAT {
                get { return vat; }
            }
            public decimal Brutto {
                get { return brutto; }
            }
            public string CechaLokalizacji {
                get {
                    if (Parametry.CechaLokalizacji == null || lokalizacja == null)
                        return "nieokreślona";
                    return lokalizacja.Features[Parametry.CechaLokalizacji].ToString();
                }
            }
        }

        class NazwaComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Lokalizacja == null ? "(brak)" : t1.Lokalizacja.Nazwa;
                string s2 = t2.Lokalizacja == null ? "(brak)" : t2.Lokalizacja.Nazwa;
                if (Parametry.CechaLokalizacji != null) {
                    string c1 = t1.Lokalizacja == null ? "" : t1.Lokalizacja.Features[Parametry.CechaLokalizacji].ToString();
                    string c2 = t2.Lokalizacja == null ? "" : t2.Lokalizacja.Features[Parametry.CechaLokalizacji].ToString();
                    s1 = c1 + ":" + s1;
                    s2 = c2 + ":" + s2;
                }
                return s1.CompareTo(s2);
            }
        }

        class KodComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Lokalizacja == null ? "(brak)" : t1.Lokalizacja.Kod;
                string s2 = t2.Lokalizacja == null ? "(brak)" : t2.Lokalizacja.Kod;
                if (Parametry.CechaLokalizacji != null) {
                    string c1 = t1.Lokalizacja == null ? "" : t1.Lokalizacja.Features[Parametry.CechaLokalizacji].ToString();
                    string c2 = t2.Lokalizacja == null ? "" : t2.Lokalizacja.Features[Parametry.CechaLokalizacji].ToString();
                    s1 = c1 + ":" + s1;
                    s2 = c2 + ":" + s2;
                }
                return s1.CompareTo(s2);
            }
        }

        void OnContextLoad(Object sender, EventArgs args) {
            Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
            if (pars.Kategoria == KategoriaHandlowa.Sprzedaż) {
                string t = string.Format("Raport sprzedaży wg lokalizacji|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.Zakup) {
                string t = string.Format("Raport zakupów wg lokalizacji|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.WydanieMagazynowe) {
                string t = string.Format("Raport wydań wg lokalizacji|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            else if (pars.Kategoria == KategoriaHandlowa.PrzyjęcieMagazynowe) {
                string t = string.Format("Raport przyjęć wg lokalizacji|</STRONG>Magazyn:<STRONG> {0}", pars.Magazyn);
                ReportHeader.Title = t;
            }
            if (pars.Kontrahent != null)
                ReportHeader.Title += string.Format("|</STRONG>Kontrahent<STRONG>: {0}", pars.Kontrahent.ToString());
            if (pars.Definicja != null)
                ReportHeader.Title += string.Format("|</STRONG>Definicja:<STRONG> {0}", pars.Definicja.ToString());
            if (pars.Okres != Soneta.Types.FromTo.All)
                ReportHeader.Title += string.Format("|</STRONG>Okres:<STRONG> {0}", pars.Okres.ToString());
            if (Parametry.CechaLokalizacji != null)
            {
                ReportHeader.Title += "|Cecha: </STRONG>" + Parametry.CechaLokalizacji.Name + "<STRONG>";
                Grid.GroupLine = "Wartość cechy " + Parametry.CechaLokalizacji.Name + ": {0}";
            }
           
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();

            if (Parametry.CechaLokalizacji != null && Parametry.WartoscCechyLokalizacji != null)
            {
                var wartosci = new List<string>();
                foreach (var w in Parametry.WartoscCechyLokalizacji)
                    wartosci.Add(w.Value.ToString());

                string[] wartosciTable = wartosci.ToArray();

                foreach (DokumentHandlowy dokument in rows) {
                    if (dokument.Anulowany) continue;
                    if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                    if (dokument.Definicja.DuplikatWartosci) continue;
                    if (dokument.OdbiorcaMiejsceDostawy == null) continue;                

                    bool jestZgodnaWartosc = false;
                    foreach (string wart in wartosciTable)
                    {
                        if (!string.IsNullOrEmpty(wart.Trim()) && wart.Trim() == dokument.OdbiorcaMiejsceDostawy.Features[Parametry.CechaLokalizacji].ToString())
                        {
                            jestZgodnaWartosc = true;
                            break;
                        }
                    }

                    if (!jestZgodnaWartosc)
                    {
                        continue;
                    } 
                                
                    Total t = (Total)result[dokument.OdbiorcaMiejsceDostawy];
                    if (t == null) {
                        t = new Total(dokument.OdbiorcaMiejsceDostawy);
                        result.Add(t.Lokalizacja, t);
                    }
                    t.Add(dokument);
                }
            }            

            ArrayList lista = new ArrayList(result.Values);
            if (Parametry.CechaLokalizacji != null && Parametry.WartoscCechyLokalizacji != null)
                switch (Parametry.SortujWedług) {
                    case SortowanieWedług.WgKoduLokalizacji:
                        lista.Sort(new KodComparer());
                        break;
                    case SortowanieWedług.WgNazwyLokalizacji:
                        lista.Sort(new NazwaComparer());
                        break;
                }
            Grid.DataSource = lista;
        }
        
    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Raport sprzedaży wg kontrahentów" runat="server">
        </eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            GroupData0="CechaLokalizacji" DataMember="Total"
            ShowGroupSum="true">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"
                    EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn Align="Left" DataMember="Lokalizacja" Caption="Lokalizacja"
                    NoWrap="True" EncodeHTML="True" runat="server" Width="30">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Lokalizacja.Kontrahent" Caption="Kontrahent" NoWrap="True"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="VAT" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="Brutto" Total="Sum" Format="{0:n}" runat="server">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

